/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logd;

import com.ibm.hwmca.base.logd.GetDisplayerName;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import java.util.HashMap;
import java.util.Properties;

public class LogDisplayerLaunch {
    private static final String TRACE_MASKT = "XLOGDTLT";
    private static final String TRACE_MASKD = "XLOGDTLD";
    private static final String TRACE_MASKF = "XLOGDTLF";
    private static final FrameworkClassLogInfo _loggerInfo = new FrameworkClassLogInfo(85, "LogDisplayer");
    private Log _logData;
    private PanelTaskletResponse _taskletResponse;
    private String _logClassStr;
    private String _logTypeStr;
    private String _logBlockIdStr;
    protected static Properties _classProperties;
    private static final String CLASS_MAP_FILE = "LogClassMap.properties";
    private static final String DEFAULT_DISPLAY_CLASS = "com.ibm.hwmca.base.logd.HexExpanderTasklet";
    protected static boolean _continueProcessing;

    public LogDisplayerLaunch(Log logData, PanelTaskletResponse taskletResponse) {
        Trace.trace(TRACE_MASKT, "-> LogDisplayerLaunch()");
        this._logData = logData;
        this._taskletResponse = taskletResponse;
        byte logClass = this._logData.getLogClass();
        this._logClassStr = HexString.toHex(logClass, true).toUpperCase();
        byte logType = this._logData.getLogType();
        this._logTypeStr = HexString.toHex(logType, true).toUpperCase();
        Trace.trace(TRACE_MASKT, "<- LogDisplayerLaunch()");
    }

    public void launchSubtasklet(LogBlock logBlock) {
        Trace.trace(TRACE_MASKF, "-> LogDisplayerLaunch.launchSubtasklet(logBlock) classType=" + this._logClassStr + this._logTypeStr);
        byte block = logBlock.getBlockId();
        this._logBlockIdStr = HexString.toHex(block, true).toUpperCase();
        Trace.trace(TRACE_MASKF, "classTypeBlock=" + this._logClassStr + this._logTypeStr + this._logBlockIdStr);
        Trace.trace(TRACE_MASKF, "Before getDisplayerName()");
        boolean classOk = _classProperties != null;
        String displayClass = GetDisplayerName.getDisplayerName(_classProperties, this._logClassStr, this._logTypeStr, this._logBlockIdStr, "JavaExp: ", classOk);
        this.launchSubtasklet(logBlock, displayClass);
        Trace.trace(TRACE_MASKF, "<- LogDisplayerLaunch.launchSubtasklet(logBlock)");
    }

    public void launchSubtasklet(LogBlock logBlock, String displayClass) {
        Trace.trace(TRACE_MASKF, "-> LogDisplayerLaunch.launchSubtasklet(logBlock,displayClass)");
        HashMap<String, Cloneable> expanderData = new HashMap<String, Cloneable>();
        expanderData.put("logObject", this._logData);
        expanderData.put("logBlockObject", logBlock);
        if (displayClass == null || displayClass.length() == 0) {
            Trace.trace(TRACE_MASKF, "display class null or 0 len");
            Trace.trace(TRACE_MASKF, "Will use the default subtasklet=com.ibm.hwmca.base.logd.HexExpanderTasklet");
            displayClass = DEFAULT_DISPLAY_CLASS;
        }
        try {
            Class.forName(displayClass);
        }
        catch (ClassNotFoundException cnfe) {
            Trace.trace(TRACE_MASKF, "Unable to find  subtasklet=" + displayClass);
            Trace.trace(TRACE_MASKF, "Will use the default subtasklet=com.ibm.hwmca.base.logd.HexExpanderTasklet");
            displayClass = DEFAULT_DISPLAY_CLASS;
        }
        Trace.trace(TRACE_MASKF, "Create subtasklet descriptor for class=" + displayClass);
        DisplayAreaDescriptorDelegate subTaskletDescriptor = new DisplayAreaDescriptorDelegate(displayClass, expanderData);
        Trace.trace(TRACE_MASKF, "Call to launch subtasklet for class=" + displayClass);
        this._taskletResponse.openModalChild(subTaskletDescriptor);
        Trace.trace(TRACE_MASKF, "<- LogDisplayerLaunch.launchSubtasklet(logBlock,displayClass)");
    }

    public void launchSubtasklet(String userChoice) {
        Trace.trace(TRACE_MASKF, "-> LogDisplayerLaunch.launchSubtasklet userChoice=" + userChoice);
        LogBlock logBlock = this.mapRadioButtonToLogBlock(userChoice);
        this.launchSubtasklet(logBlock);
        Trace.trace(TRACE_MASKF, "<- LogDisplayerLaunch.launchSubtasklet userChoice=" + userChoice);
    }

    private LogBlock mapRadioButtonToLogBlock(String userChoice) {
        LogBlock logBlock = null;
        boolean found = true;
        int blockId = 0;
        if (userChoice.equals("PrimaryDataBlockItem")) {
            blockId = 3;
        } else if (userChoice.equals("StandardDataBlockItem")) {
            blockId = 1;
        } else if (userChoice.equals("ModifyDataBlockItem")) {
            blockId = 0;
        } else if (userChoice.equals("SystemEventMsgItem")) {
            blockId = -15;
        } else if (userChoice.equals("EngDataBlockItem")) {
            blockId = 2;
        } else if (userChoice.equals("MicrocodeErrorInfoItem")) {
            blockId = -16;
        } else if (userChoice.equals("DataBlockItem")) {
            blockId = -14;
        } else if (userChoice.equals("HardwareBlockItem")) {
            blockId = -12;
        } else {
            found = false;
        }
        if (found) {
            logBlock = this._logData.getLogBlock((byte)blockId);
        }
        return logBlock;
    }

    static {
        try {
            _continueProcessing = true;
            _classProperties = null;
            _classProperties = GetDisplayerName.getMapping(CLASS_MAP_FILE, "JavaExp: ");
            Trace.trace(TRACE_MASKF, "log class map properties ready for use");
        }
        catch (Throwable exc) {
            _continueProcessing = false;
            Trace.trace(TRACE_MASKF, "In static: Error accessing log class map properties file=LogClassMap.properties");
            Trace.trace(TRACE_MASKF, exc);
        }
    }
}

